---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-ヘルプモード（help?>）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **apropos検索のフォールバック動作**: 具体的な実装箇所の確認が必要
  2. **拡張ヘルプ(??プレフィックス)の詳細動作**: extended_help_onの具体的な効果を確認
  3. **Markdownレンダリングの詳細**: ターミナルレンダリングの実装を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/REPL/src/docview.jl` 23-30行 - helpmode()関数
- E-02: `stdlib/REPL/src/docview.jl` 36-77行 - _helpmode()関数
- E-03: `stdlib/REPL/src/docview.jl` 34行 - extended_help_on参照
- E-04: `stdlib/REPL/src/docview.jl` 79-97行 - formatdoc(), parsedoc()
- E-05: `stdlib/REPL/src/REPL.jl` 1304-1312行 - help_modeのPrompt設定
- E-06: `stdlib/REPL/src/REPL.jl` 1200-1228行 - mode_keymap()
- E-07: `stdlib/REPL/src/REPL.jl` 116行 - HELP_PROMPT定数
- E-08: `docs/code-to-docs/画面遷移図.md` - 画面遷移定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ?キーで行頭入力時にヘルプモードに遷移する | E-05, E-08 | ○ |
| C-02 | プロンプトが「help?>」である | E-07 | ○ |
| C-03 | helpmode()がメインエントリポイントである | E-01 | ○ |
| C-04 | _helpmode()で入力をMeta.parseする | E-02 (55行) | ○ |
| C-05 | キーワードはkeywords辞書から直接取得する | E-02 (58行) | ○ |
| C-06 | ??プレフィックスで拡張ヘルプが有効になる | E-02 (39-46行), E-03 | ○ |
| C-07 | #で始まる入力はコメントヘルプとして処理される | E-02 (48-54行) | ○ |
| C-08 | @macronameと@macroname()が区別される | E-02 (71行) | ○ |
| C-09 | @replマクロを介してBase.Docsの名前空間で検索する | E-02 (75行) | ○ |
| C-10 | Markdown.insert_hlinesでドキュメントを整形する | E-01 (26行) | ○ |
| C-11 | insert_internal_warningで非公開シンボル警告を挿入する | E-01 (27行) | ○ |
| C-12 | internal_accessesセットで非公開アクセスを追跡する | E-01 (24行) | ○ |
| C-13 | BackspaceまたはCtrl+CでJuliaプロンプトに戻る | E-06, E-08 | ○ |
| C-14 | on_doneでhelpmode()が呼び出される | E-05 (1311行) | ○ |
| C-15 | formatdoc()がDocStrをMarkdownに変換する | E-04 (79-87行) | ○ |
| C-16 | parsedoc()がDocStrをパースしキャッシュする | E-04 (89-97行) | ○ |
| C-17 | using/importはキーワードとして特別扱いされる | E-02 (63-64行) | ○ |
| C-18 | 8種類の関連機能が存在する | E-09 | ○ |
| C-19 | docstringが見つからない場合apropos検索にフォールバックする | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: apropos検索のフォールバック動作は `docview.jl` 内の `@repl` マクロの実装を詳細に確認する必要がある。`Base.Docs.apropos` 関数は存在するが、フォールバックの具体的なトリガー条件の確認が不足。
  - 候補：`stdlib/REPL/src/docview.jl` 内の repl マクロ定義 / `base/docs/Docs.jl` 内の apropos()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ヘルプモードは読み取り専用でシステムに副作用がない
- 1: 中リスク - 非公開シンボル警告の正確な表示条件の確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] helpmode()と_helpmode()の処理フローが正しく記述されているか確認
- [ ] ??プレフィックスによる拡張ヘルプの動作記述が正しいか確認
- [ ] モード遷移（?キー、Backspace、Ctrl+C）の記述が正しいか確認
- [ ] 関連機能8種類が画面機能マッピングと一致しているか確認
